<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Production extends Model
{
    use HasFactory;

    protected $fillable = [
        'production_date',
        'cost_material',
        'operational_cost',
        'notes',
    ];

    protected $casts = [
        'production_date' => 'date', 
    ];

    public function details()
    {
        return $this->hasMany(ProductionDetail::class);
    }
}
