<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Reseller extends Model
{
    protected $fillable = [
        'name',
        'address',
        'phone',
        'maps',
    ];

    public function stocks()
    {
        return $this->hasMany(ResellerStock::class);
    }

    public function orders()
    {
        return $this->hasMany(ResellerOrder::class);
    }

    public function payments()
    {
        return $this->hasMany(ResellerPayment::class);
    }
}
