<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ResellerPayment extends Model
{
    protected $fillable = [
        'reseller_id',
        'reseller_order_id',
        'amount_due',
        'amount_paid',
        'status',
    ];

    public function reseller()
    {
        return $this->belongsTo(Reseller::class);
    }

    public function resellerOrder()
    {
        return $this->belongsTo(ResellerOrder::class, 'reseller_order_id');
    }

    public function histories()
    {
        return $this->hasMany(ResellerPaymentHistory::class, 'reseller_payment_id');
    }

}

