<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ResellerStock extends Model
{
    protected $fillable = [
        'batch_id',
        'reseller_id',
        'product_id',
        'stock',
        'recorded_at',
    ];

    protected $casts = [
        'recorded_at' => 'date',
    ];

    public function reseller()
    {
        return $this->belongsTo(Reseller::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
