@props([
    'id',
    'resource' => null,
    'editRoute' => null, 
    'deleteRoute' => null,
    'viewRoute' => null,
    'confirmMessage' => 'Are you sure?'
])

<?php
    $editUrl   = $editRoute   ?? ($resource ? route($resource . '.edit', $id)   : null);
    $deleteUrl = $deleteRoute ?? ($resource ? route($resource . '.destroy', $id): null);
    $viewUrl   = $viewRoute   ?? ($resource ? route($resource . '.show', $id)   : null);
?>

<div class="d-flex align-items-center gap-1">
    @if($editUrl)
        <a href="{{ $editUrl }}"
            class="btn px-2 py-1"
            style="background-color: #d4af37; color: #ffffff; border-radius: 6px;"
            title="Edit">
            <i class="bi bi-pen"></i>
        </a>
    @endif

    @if($deleteUrl)
        <form method="POST" action="{{ $deleteUrl }}" class="d-inline">
            @csrf
            @method('DELETE')

            <button type="submit"
                class="btn px-2 py-1"
                style="background-color: #8c2b25; color: #ffffff; border-radius: 6px;"
                title="Delete"
                onclick="return confirm('{{ $confirmMessage }}')">
                <i class="bi bi-trash"></i>
            </button>
        </form>
    @endif

    @if($viewUrl)
        <a href="{{ $viewUrl }}"
            class="btn px-2 py-1"
            style="background-color: #0f8d06; color: #ffffff; border-radius: 6px;"
            title="View">
            <i class="bi bi-eye"></i>
        </a>
    @endif
</div>
