@props([
    'name',
    'label' => null,
    'inRowLabel' => null,
    'type' => 'text',
    'value' => old($name),
    'placeholder' => '',
    'required' => false,
    'disabled' => false,
    'class' => '',
])

<style>
    .input-theme {
        background: #f6e4bd !important;
        color: #661b18 !important;
        border: 1px solid #d4af37 !important;
        border-radius: 6px;
        padding: 8px 12px;
        font-size: 15px;
    }

    .input-theme:focus {
        border-color: #c19d2f !important;
        box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.25) !important;
        outline: none !important;
    }

    .input-theme[type="date"]::-webkit-calendar-picker-indicator {
        filter: invert(68%) sepia(46%) saturate(360%) hue-rotate(2deg) brightness(95%) contrast(90%);
    }

    .label-theme {
        color: #661b18;
        font-weight: 600;
        margin-bottom: 4px;
        display: inline-block;
    }

    .input-error {
        color: #b70000;
        font-size: 14px;
        margin-top: 4px;
    }
</style>

@if ($inRowLabel)
    <div class="row mb-3 align-items-center w-100">
        <label for="{{ $name }}" class="col-lg-2 col-form-label label-theme">
            {{ $inRowLabel }}
        </label>

        <div class="col-lg-10">
            <input
                type="{{ $type }}"
                name="{{ $name }}"
                id="{{ $name }}"
                value="{{ $value }}"
                placeholder="{{ $placeholder }}"
                @if ($required) required @endif
                @if ($disabled) disabled @endif
                class="form-control input-theme {{ $class }}"
                {{ $attributes }}
            />

            @error($name)
                <div class="input-error">{{ $message }}</div>
            @enderror
        </div>
    </div>

@else
    <div class="mb-3 w-100">
        @if ($label)
            <label for="{{ $name }}" class="label-theme">
                {{ $label }}
            </label>
        @endif

        <input
            type="{{ $type }}"
            name="{{ $name }}"
            id="{{ $name }}"
            value="{{ $value }}"
            placeholder="{{ $placeholder }}"
            @if ($required) required @endif
            @if ($disabled) disabled @endif
            class="form-control input-theme {{ $class }}"
            {{ $attributes }}
        />

        @error($name)
            <div class="input-error">{{ $message }}</div>
        @enderror
    </div>
@endif
