<div class="table-responsive">
    <style>
        .table .truncate {
            display: block;
            max-width: 220px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .table th, .table td { vertical-align: middle; }
        @media (max-width: 480px) {
            .table .truncate { white-space: normal; max-width: none; }
        }
    </style>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                @foreach ($headers as $header)
                    <th>{{ $header }}</th>
                @endforeach
            </tr>
        </thead>

        <tbody>
            @forelse ($rows as $row)
                <tr>
                    @foreach ($row['cols'] as $col)
                        <td>
                            <div class="truncate" title="{{ strip_tags($col) }}">
                                {{ $col }}
                            </div>
                        </td>
                    @endforeach

                    @if (isset($row['actions']))
                        <td class="text-center">
                            {!! $row['actions'] !!}
                        </td>
                    @endif
                </tr>
            @empty
                <tr>
                    <td colspan="{{ count($headers) }}" class="text-center text-muted py-3">
                        No data available.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
