<!doctype html>
<html lang="en">
  <!--begin::Head-->
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title class="title-color">@yield("title")</title>
    <!--begin::Primary Meta Tags-->
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="title" content="AdminLTE 4 | Unfixed Sidebar" />
    <meta name="author" content="ColorlibHQ" />
    <meta
      name="description"
      content="AdminLTE is a Free Bootstrap 5 Admin Dashboard, 30 example pages using Vanilla JS."
    />
    <meta
      name="keywords"
      content="bootstrap 5, bootstrap, bootstrap 5 admin dashboard, bootstrap 5 dashboard, bootstrap 5 charts, bootstrap 5 calendar, bootstrap 5 datepicker, bootstrap 5 tables, bootstrap 5 datatable, vanilla js datatable, colorlibhq, colorlibhq dashboard, colorlibhq admin dashboard"
    />
    <!--end::Primary Meta Tags-->
    <!--begin::Fonts-->
    <link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/@fontsource/source-sans-3@5.0.12/index.css"
      integrity="sha256-tXJfXfp6Ewt1ilPzLDtQnJV4hclT9XuaZUKyUvmyr+Q="
      crossorigin="anonymous"
    />
    <!--end::Fonts-->
    <!--begin::Third Party Plugin(OverlayScrollbars)-->
    <link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.10.1/styles/overlayscrollbars.min.css"
      integrity="sha256-tZHrRjVqNSRyWg2wbppGnT833E/Ys0DHWGwT04GiqQg="
      crossorigin="anonymous"
    />
    <!--end::Third Party Plugin(OverlayScrollbars)-->
    <!--begin::Third Party Plugin(Bootstrap Icons)-->
    <link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css"
      integrity="sha256-9kPW/n5nn53j4WMRYAxe9c1rCY96Oogo/MKSVdKzPmI="
      crossorigin="anonymous"
    />
    <!--end::Third Party Plugin(Bootstrap Icons)-->
    <!--begin::Required Plugin(AdminLTE)-->
    <link rel="stylesheet" href="{{ asset('assets/css/adminlte.css') }}" />
    <!--end::Required Plugin(AdminLTE)-->
    <!--begin::piazhang Theme Override-->
    <link rel="stylesheet" href="{{ asset('assets/css/theme.css') }}">
    <!--end::piazhang Theme Override-->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
  </head>
  <!--end::Head-->
  <!--begin::Body-->
  <body class="sidebar-expand-lg bg-body-tertiary">
    <!--begin::App Wrapper-->
    <div class="app-wrapper">
      <!--begin::Header-->
      <nav class="app-header navbar navbar-expand bg-body">
        <!--begin::Container-->
        <div class="container-fluid">
          <!--begin::Start Navbar Links-->
          <ul class="navbar-nav">
            <li class="nav-item">
              <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button">
                <i class="bi bi-list"></i>
              </a>
            </li>
          </ul>
          <!--end::Start Navbar Links-->
          <!--begin::End Navbar Links-->
          <ul class="navbar-nav ms-auto">
            <form method="POST" action="{{ route('logout') }}">
              @csrf
              <button type="submit" class="btn-logout">
                {{ __('Logout') }}
              </button>
            </form>
          </ul>
          <!--end::End Navbar Links-->
        </div>
        <!--end::Container-->
      </nav>
      <!--end::Header-->
      <!--begin::Sidebar-->
      <aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark">
        <!--begin::Sidebar Brand-->
        <div class="sidebar-brand">
          <!--begin::Brand Link-->
          <a class='brand-link' href='/dashboard'>
            <!--begin::Brand Image-->
            <img
              src="{{ asset('assets/img/logo/logo1.png') }}"
              alt="Logo"
              class="brand-image"
            />
            <!--end::Brand Image-->
          </a>
          <!--end::Brand Link-->
        </div>
        <!--end::Sidebar Brand-->
        <!--begin::Sidebar Wrapper-->
        <div class="sidebar-wrapper">
          <nav class="mt-2">
            <ul class="nav sidebar-menu flex-column" data-lte-toggle="treeview" role="menu" data-accordion="false">
                <!-- Dashboard -->
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('dashboard') }}">
                        <i class="bi bi-speedometer2"></i>
                        <p>Dashboard</p>
                    </a>
                </li>

                <!-- Profile -->
                @if(auth()->user()->role === 'owner')
                  <li class="nav-item">
                      <a class="nav-link" href="{{ route('profile.index') }}">
                          <i class="bi bi-person"></i>
                          <p>Profile</p>
                      </a>
                  </li>
                @endif

                <!-- Users -->
                @if(auth()->user()->role === 'owner')
                  <li class="nav-item">
                      <a class="nav-link" href="{{ route('users.index') }}">
                          <i class="bi bi-people"></i>
                          <p>User</p>
                      </a>
                  </li>
                @endif

                <!-- Portofolio -->
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('portofolios.index') }}">
                        <i class="bi bi-images"></i>
                        <p>Portofolio</p>
                    </a>
                </li>

                <!-- Reports -->
                <li class="nav-header">Laporan</li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('reports.index') }}">
                        <i class="bi bi-bar-chart"></i>
                        <p>Laporan Mingguan</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('reports.monthly') }}">
                        <i class="bi bi-calendar-month"></i>
                        <p>Laporan Bulanan</p>
                    </a>
                </li>

                <!-- Products -->
                <li class="nav-header">Products</li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('products.index') }}">
                        <i class="bi bi-box-seam"></i>
                        <p>Daftar Produk</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('productions.index') }}">
                        <i class="bi bi-clipboard-plus"></i>
                        <p>Produksi Barang</p>
                    </a>
                </li>

                <!-- Orders -->
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('orders.index') }}">
                        <i class="bi bi-bag-check"></i>
                        <p>Customer Orders</p>
                    </a>
                </li>

                <!-- Resellers -->
                <li class="nav-header">Resellers</li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('resellers.index') }}">
                        <i class="bi bi-people"></i>
                        <p>Daftar Reseller</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('reseller-orders.index') }}">
                        <i class="bi bi-bag-check"></i>
                        <p>Order Reseller</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('reseller-stocks.index') }}">
                        <i class="bi bi-boxes"></i>
                        <p>Stok Reseller</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('reseller-payments.index') }}">
                        <i class="bi bi-cash-coin"></i>
                        <p>Pembayaran Reseller</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('reseller-barters.index') }}">
                        <i class="bi bi-arrow-left-right"></i>
                        <p>Barter Reseller</p>
                    </a>
                </li>

            </ul>
        </nav>


        </div>
        <!--end::Sidebar Wrapper-->
      </aside>
      <!--end::Sidebar-->
      <!--begin::App Main-->
      <main class="app-main">
        <!--begin::App Content Header-->
        <div class="app-content-header">
          <!--begin::Container-->
          <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
              <div class="col-sm-6 font-playfair"><h3 class="mb-3 title-color">@yield("title")</h3></div>
              <div class="col-sm-6">
              </div>
            </div>
            <!--end::Row-->
          </div>
          <!--end::Container-->
        </div>
        <!--end::App Content Header-->
        <!--begin::App Content-->
        <div class="app-content">
          <!--begin::Container-->
          <div class="container-fluid">
            <!--begin::Row-->
            @yield('content')
            <!--end::Row-->
          </div>
        </div>
        <!--end::App Content-->
      </main>
      <!--end::App Main-->
      <!--begin::Footer-->
      <footer class="app-footer">
        <!--begin::Copyright-->
        <strong>
          © {{ date('Y') }} Pia Zhang. All rights reserved.
        </strong>
        <!--end::Copyright-->
      </footer>
      <!--end::Footer-->
    </div>
    <!--end::App Wrapper-->
    <!--begin::Script-->
    <!--begin::Third Party Plugin(OverlayScrollbars)-->
    <script
      src="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.10.1/browser/overlayscrollbars.browser.es6.min.js"
      integrity="sha256-dghWARbRe2eLlIJ56wNB+b760ywulqK3DzZYEpsg2fQ="
      crossorigin="anonymous"
    ></script>
    <!--end::Third Party Plugin(OverlayScrollbars)--><!--begin::Required Plugin(popperjs for Bootstrap 5)-->
    <script
      src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
      integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r"
      crossorigin="anonymous"
    ></script>
    <!--end::Required Plugin(popperjs for Bootstrap 5)--><!--begin::Required Plugin(Bootstrap 5)-->
    <script
      src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"
      integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy"
      crossorigin="anonymous"
    ></script>
    <!--end::Required Plugin(Bootstrap 5)--><!--begin::Required Plugin(AdminLTE)-->
    <script src="{{ asset('assets/js/adminlte.js') }}"></script>
    <!--end::Required Plugin(AdminLTE)--><!--begin::OverlayScrollbars Configure-->
    <script>
      const SELECTOR_SIDEBAR_WRAPPER = '.sidebar-wrapper';
      const Default = {
        scrollbarTheme: 'os-theme-light',
        scrollbarAutoHide: 'leave',
        scrollbarClickScroll: true,
      };
      document.addEventListener('DOMContentLoaded', function () {
        const sidebarWrapper = document.querySelector(SELECTOR_SIDEBAR_WRAPPER);
        if (sidebarWrapper && typeof OverlayScrollbarsGlobal?.OverlayScrollbars !== 'undefined') {
          OverlayScrollbarsGlobal.OverlayScrollbars(sidebarWrapper, {
            scrollbars: {
              theme: Default.scrollbarTheme,
              autoHide: Default.scrollbarAutoHide,
              clickScroll: Default.scrollbarClickScroll,
            },
          });
        }
      });
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- SweetAlert JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.0/sweetalert.min.js"></script>

  <script type="text/javascript">
      $('.show_confirm').click(function(event) {
          var form = $(this).closest("form");
          var nama = $(this).data("nama");
          event.preventDefault();
          swal({
              title: `Are you sure you want to delete this ${name} data?`,
              text: "If you delete this, it will be gone forever.",
              icon: "warning",
              buttons: true,
              dangerMode: true,
          }).then((willDelete) => {
              if (willDelete) {
                  form.submit();
              }
          });
      });

      @if (session('success'))
          swal({
              title: "Good Job!",
              text: "{{ session('success') }}",
              icon: "success",
          });
      @endif

      @if (session('error'))
      swal({
          title: "Oops!",
          text: "{{ session('error') }}",
          icon: "error",
      });
      @endif

  </script>
  <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
  <script>
    window.addEventListener('load', function () {
        AOS.init({
            once: false,
            mirror: true,
            offset: 0,
        });

        setTimeout(() => AOS.refresh(), 100);
    });
  </script>
    <!--end::OverlayScrollbars Configure-->
    <!--end::Script-->
  </body>
  <!--end::Body-->
</html>
