@extends('layout.main')
@section('title', 'Detail Pesanan')
@section('content')

<div class="container">
    <div class="mb-3"><strong>Customer:</strong> {{ $order->customer_name }}</div>
    <div class="mb-3"><strong>No Telp:</strong> {{ $order->customer_phone ?? '-' }}</div>
    <div class="mb-3"><strong>Status:</strong> {{ ucfirst($order->status) }}</div>
    <div class="mb-3"><strong>Total Harga:</strong> Rp {{ number_format($order->total_price,0,',','.') }}</div>
    <div class="mb-3"><strong>Tanggal Pesan:</strong> {{ \Carbon\Carbon::parse($order->order_date)->format('d F Y') }}</div>

    @if($order->status === 'scheduled')
        <div class="mb-3"><strong>Tanggal Ambil:</strong> {{ \Carbon\Carbon::parse($order->pickup_date)->format('d F Y') }}</div>
    @endif

    <h5>Products</h5>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Nama Produk</th>
                <th>Jumlah</th>
                <th>Harga</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($order->details as $detail)
            <tr>
                <td>{{ $detail->product->name }}</td>
                <td>{{ $detail->qty }}</td>
                <td>Rp {{ number_format($detail->price,0,',','.') }}</td>
                <td>Rp {{ number_format($detail->qty * $detail->price,0,',','.') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <x-gold-button type="button"
        onclick="window.location.href='{{ route('orders.index') }}'">
        Back
    </x-gold-button>
</div>

@endsection