@extends('layout.main') 
@section('title', 'Edit Portofolio') 
@section('content')

<div class="container">
    <form method="POST" action="{{ route('portofolios.update', $portofolio->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <input type="hidden" name="remove_image" id="remove_image" value="0">

        <div class="d-flex justify-content-between align-items-start flex-lg-row flex-column">

            <div class="text-center p-4 pt-0 d-flex flex-column">

                <label for="image" class="upload-box d-flex flex-column align-items-center justify-content-center" style="min-height:200px;">

                    <div id="image-preview" class="d-flex align-items-center justify-content-center w-100 h-100">
                        @if($portofolio->image)
                            <img id="preview-img" 
                                 src="{{ asset($portofolio->image) }}" 
                                 style="display:block; width:100%; height:120px; object-fit:contain;">
                            <div id="image-instruction" class="text-muted" style="display:none;">Upload Photo</div>
                        @else
                            <div id="image-instruction" class="text-muted">Upload Photo</div>
                        @endif
                    </div>

                    <img id="preview-img-new" 
                         src="#" 
                         style="display:none; width:100%; height:120px; object-fit:contain;">

                    <div id="file-name-new" style="display:none;"></div>
                </label>

                <input 
                    type="file" 
                    name="image" 
                    id="image" 
                    class="d-none" 
                    accept="image/*"
                    onchange="previewImage(event)"
                >

                @error('image')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror

                <button type="button" id="remove-image-btn"
                    class="btn btn-outline-danger remove-btn mt-2"
                    style="{{ $portofolio->image ? 'display:inline-block;' : 'display:none;' }}"
                    onclick="removeImage()"
                >
                    Remove File
                </button>

            </div>

            <div class="w-100">

                <x-input-text
                    inRowLabel="Judul"
                    name="title"
                    required
                    placeholder="Masukkan judul portofolio"
                    :value="old('title', $portofolio->title)"
                    :errorMessage="$errors->first('title')"
                />

                <x-input-text-area
                    inRowLabel="Deskripsi"
                    name="description"
                    rows="3"
                    required
                    placeholder="Masukkan deskripsi portofolio"
                    :value="old('description', $portofolio->description)"
                    :errorMessage="$errors->first('description')"
                />

                <div class="d-flex justify-content-between pe-2 mt-4">
                    <x-gold-button type="button" onclick="window.location.href='{{ route('portofolios.index') }}'">
                        <i class="bi bi-arrow-left"></i> Back
                    </x-gold-button>

                    <x-button type="submit">
                        Update Portofolio
                    </x-button>
                </div>

            </div>

        </div>
    </form>
</div>

<script>
function previewImage(event) {
    const input = event.target;
    const previewNew = document.getElementById('preview-img-new');
    const previewOld = document.getElementById('preview-img');
    const instruction = document.getElementById('image-instruction');
    const removeBtn = document.getElementById('remove-image-btn');
    const removeFlag = document.getElementById('remove_image');
    const fileNameNew = document.getElementById('file-name-new');

    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = e => {
            previewNew.src = e.target.result;
            previewNew.style.display = 'block';
        };
        reader.readAsDataURL(input.files[0]);

        fileNameNew.textContent = input.files[0].name;
        fileNameNew.style.display = 'block';

        if (previewOld) previewOld.style.display = 'none';
        instruction.style.display = 'none';
        removeBtn.style.display = 'inline-block';
        removeFlag.value = 0;
    }
}

function removeImage() {
    const input = document.getElementById('image');
    const previewOld = document.getElementById('preview-img');
    const previewNew = document.getElementById('preview-img-new');
    const instruction = document.getElementById('image-instruction');
    const removeBtn = document.getElementById('remove-image-btn');
    const removeFlag = document.getElementById('remove_image');
    const fileNameNew = document.getElementById('file-name-new');

    input.value = "";
    if (previewOld) previewOld.style.display = 'none';
    previewNew.style.display = 'none';
    instruction.style.display = 'block';
    fileNameNew.style.display = 'none';
    removeBtn.style.display = 'none';
    removeFlag.value = 1;
}
</script>

@endsection
