@extends('layout.main')
@section('title', 'Detail Produksi')
@section('content')

<div class="container">

    <div class="w-100">

        <div class="mb-3">
            <label class="field-label">Tanggal Produksi</label>
            <input type="text" class="form-control field-value" value="{{ $production->production_date->format('d F Y') }}" disabled>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="field-label">Biaya Bahan (Rp)</label>
                <input type="text" class="form-control field-value" value="{{ number_format($production->cost_material,0,',','.') }}" disabled>
            </div>

            <div class="col-md-6 mb-3">
                <label class="field-label">Biaya Operasional (Rp)</label>
                <input type="text" class="form-control field-value" value="{{ number_format($production->operational_cost,0,',','.') }}" disabled>
            </div>
        </div>

        <div class="mb-3">
            <label class="field-label">Catatan</label>
            <textarea class="form-control field-value" rows="2" disabled>{{ $production->notes ?? '-' }}</textarea>
        </div>

        <h5 class="mt-4">Detail Produk</h5>
        <div class="table-responsive">
            @php
                $headers = ['Produk', 'Jumlah Diproduksi'];

                $rows = $production->details->map(function($detail) {
                    return [
                        'cols' => [
                            $detail->product->name,
                            $detail->quantity,
                        ]
                    ];
                });
            @endphp


            <div class="table-responsive">
                <style>
                    .table .truncate {
                        display: block;
                        max-width: 220px;
                        white-space: nowrap;
                        overflow: hidden;
                        text-overflow: ellipsis;
                    }
                    .table th, .table td { vertical-align: middle; }
                    @media (max-width: 480px) {
                        .table .truncate { white-space: normal; max-width: none; }
                    }
                </style>

                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            @foreach ($headers as $header)
                                <th>{{ $header }}</th>
                            @endforeach
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($rows as $row)
                            <tr>
                                @foreach ($row['cols'] as $col)
                                    <td>
                                        <div class="truncate" title="{{ strip_tags($col) }}">
                                            {{ $col }}
                                        </div>
                                    </td>
                                @endforeach
                            </tr>
                        @empty
                            <tr>
                                <td colspan="{{ count($headers) }}" class="text-center text-muted py-3">
                                    No data available.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <div class="d-flex justify-content-between pe-2 mt-4">
            <x-gold-button onclick="window.location.href='{{ route('productions.index') }}'">
                <i class="bi bi-arrow-left"></i> Kembali
            </x-gold-button>

            <x-button onclick="window.location.href='{{ route('productions.edit', $production->id) }}'">
                Edit Produksi
            </x-button>
        </div>

        <div class="text-muted small mt-3">
            Dibuat: {{ $production->created_at?->format('Y-m-d H:i') ?? '-' }}
            &nbsp;|&nbsp;
            Diperbarui: {{ $production->updated_at?->format('Y-m-d H:i') ?? '-' }}
        </div>

    </div>

</div>

@endsection
