@extends('layout.main') 
@section('title', 'Tambah Produk') 
@section('content')

<style>
/* Biar jelas kelihatan disabled */
input:disabled {
    background-color: #e9ecef !important;
    cursor: not-allowed;
}
</style>

<div class="container">
    <form method="POST" action="{{ route('products.store') }}" enctype="multipart/form-data">
        @csrf

        <div class="d-flex justify-content-between align-items-start flex-lg-row flex-column">

            {{-- Upload Photo --}}
            <div class="text-center p-4 pt-0 d-flex flex-column">
                
                <label for="image" class="upload-box d-flex flex-column align-items-center justify-content-center">
                    <div id="image-preview">
                        <div id="image-instruction">Upload Photo</div>
                    </div>

                    <img id="preview-img" src="#" alt="Preview" style="display:none; max-width:200px;">

                    <div id="file-name"></div>
                </label>

                <input 
                    type="file" 
                    name="image" 
                    id="image" 
                    class="d-none" 
                    accept="image/*"
                    onchange="previewImage(event)"
                >

                @error('image')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror

                <button type="button" id="remove-image-btn"
                    class="btn btn-outline-danger remove-btn"
                    style="display:none;"
                    onclick="removeImage()"
                >
                    Remove File
                </button>
            </div>

            {{-- Right Side Inputs --}}
            <div class="w-100">

                <x-input-text
                    inRowLabel="Nama Produk"
                    name="name"
                    required
                    placeholder="Masukkan nama produk"
                    :value="old('name')"
                    :errorMessage="$errors->first('name')"
                />

                <x-input-text
                    inRowLabel="Harga"
                    name="price"
                    required
                    placeholder="Masukkan harga produk"
                    :value="old('price')"
                    :errorMessage="$errors->first('price')"
                />

                <x-input-select
                    inRowLabel="Tersedia untuk Reseller"
                    name="available_for_reseller"
                    :options="['0' => 'Tidak', '1' => 'Ya']"
                    :value="old('available_for_reseller', 0)"
                />

                <x-input-text
                    inRowLabel="Harga Reseller"
                    name="reseller_price"
                    placeholder="Masukkan harga reseller"
                    :value="old('reseller_price')"
                    :errorMessage="$errors->first('reseller_price')"
                />

                <x-input-text-area
                    inRowLabel="Deskripsi"
                    name="description"
                    rows="3"
                    required
                    placeholder="Masukkan deskripsi produk"
                    :errorMessage="$errors->first('description')"
                />
                
                <div class="d-flex justify-content-between pe-2 mt-4">
                    <x-gold-button type="button" onclick="window.location.href='{{ route('products.index') }}'">
                        <i class="bi bi-arrow-left"></i> Back
                    </x-gold-button>

                    <x-button type="submit">
                        Add Product
                    </x-button>
                </div>

            </div>

        </div>
    </form>
</div>

<script>
function previewImage(event) {
    const input = event.target;
    const preview = document.getElementById('preview-img');
    const fileName = document.getElementById('file-name');
    const instruction = document.getElementById('image-instruction');
    const removeBtn = document.getElementById('remove-image-btn');

    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = e => {
            preview.src = e.target.result;
            preview.style.display = 'block';
        };
        reader.readAsDataURL(input.files[0]);

        fileName.textContent = input.files[0].name;
        instruction.style.display = 'none';
        removeBtn.style.display = 'inline-block';
    }
}

function removeImage() {
    const input = document.getElementById('image');
    input.value = "";
    document.getElementById('preview-img').style.display = 'none';
    document.getElementById('file-name').textContent = '';
    document.getElementById('image-instruction').style.display = 'block';
    document.getElementById('remove-image-btn').style.display = 'none';
}

document.addEventListener('DOMContentLoaded', function () {

    const availableSelect = document.querySelector('[name="available_for_reseller"]');
    const resellerPriceInput = document.querySelector('[name="reseller_price"]');

    function toggleResellerPrice() {
        if (availableSelect.value === '1') {
            resellerPriceInput.disabled = false;
            resellerPriceInput.required = true;
        } else {
            resellerPriceInput.disabled = true;
            resellerPriceInput.required = false;
            resellerPriceInput.value = '';
        }
    }

    toggleResellerPrice();

    availableSelect.addEventListener('change', toggleResellerPrice);
});
</script>

@endsection
