<div class="container content">
  <div class="title-v3 text-center">
    <h2>Contact Us</h2>
    <p>
      Hubungi kami untuk pemesanan atau informasi lebih lanjut mengenai produk kami.<br>
      Kami siap melayani Anda dengan sepenuh hati.
    </p>
  </div>

  <div class="row">
    <div class="col-md-8 col-sm-12">
      <div class="contact-map">
        <div class="maroon-border">
            @if($ownerProfile && $ownerProfile->maps)
                {!! $ownerProfile->maps !!}
            @endif
        </div>
      </div>
    </div>

    <div class="col-md-4 col-sm-12">
      <p class="lead padding-bottom-10">
        Ingin mengetahui lebih banyak tentang kami? Silakan kunjungi lokasi atau hubungi kami melalui informasi berikut.
      </p>
      <ul class="list-unstyled contact-list">
        <li>
          <div class="contact-item">
            <i class="icon-custom icon-sm rounded-x icon-bg-maroon fa fa-home"></i>
            <div>
              <h6>Alamat</h6>
              <p>{{ $ownerProfile->address ?? '-' }}</p>
            </div>
          </div>
        </li>

        <li>
          <div class="contact-item">
            <i class="icon-custom icon-sm rounded-x icon-bg-maroon fa fa-phone"></i>
            <div>
              <h6>Telepon</h6>
              <p>{{ $ownerUser->phone ?? '-' }}</p>
            </div>
          </div>
        </li>

        <li>
          <div class="contact-item">
            <i class="icon-custom icon-sm rounded-x icon-bg-maroon fa fa-envelope"></i>
            <div>
              <h6>Email</h6>
              <a href="mailto:{{ $ownerUser->email ?? '' }}" class="link-black">
                {{ $ownerUser->email ?? '-' }}
              </a>
            </div>
          </div>
        </li>

        <li>
          <div class="contact-item">
            <i class="icon-custom icon-sm rounded-x icon-bg-maroon fa fa-instagram"></i>
            <div>
              <h6>Instagram</h6>
              @if($ownerProfile && $ownerProfile->instagram)
                <a href="https://instagram.com/{{ ltrim($ownerProfile->instagram, '@') }}" target="_blank" class="link-black">
                  {{ $ownerProfile->instagram }}
                </a>
              @else
                -
              @endif
            </div>
          </div>
        </li>
      </ul>
    </div>
  </div>
</div>