<div>
  <div class="container content-lg">
    <div class="title-v1 text-center">
      <h2>Our Product</h2>
      <p>
        Nikmati berbagai pilihan pia khas kami<br>
        dibuat dengan resep turun-temurun dan sentuhan rasa modern.
      </p>
      <ul class="list-inline social-icons-v1">
        @if($ownerProfile && $ownerProfile->shopee)
            <li>
                <a href="{{ $ownerProfile->shopee }}" target="_blank" class="text-cream">
                    <i class="rounded-x fa fa-shopping-cart fa-1x icon-cream"></i>
                    Shopee
                </a>
            </li>
        @endif

        @if($ownerProfile && $ownerProfile->tokopedia)
            <li>
                <a href="{{ $ownerProfile->tokopedia }}" target="_blank" class="text-cream">
                    <i class="rounded-x fa fa-tags fa-1x icon-cream"></i>
                    Tokopedia
                </a>
            </li>
        @endif
    </ul>
    </div>

    <div class="row news-v2">

      @foreach($products as $product)
      <div class="col-lg-4 col-md-6 col-sm-12 sm-margin-bottom-20 d-flex">
        <div class="product-card flex-fill">

          <div class="news-v2-badge">
            <img class="img-responsive gold-border"
                 src="{{ $product->image ? asset($product->image) : asset('assets/img/default/img-default.jpg') }}"
                 onerror="this.onerror=null;this.src='{{ asset('assets/img/default/img-default.jpg') }}';"
                 alt="{{ $product->name }}">
          </div>

          <div class="news-v2-desc">
            <h3>{{ $product->name }}</h3>
            <p>{{ $product->description }}</p>
          </div>

        </div>
      </div>
      @endforeach

    </div>
  </div>
</div>


<style>
.news-v2 {
    display: flex;
    flex-wrap: wrap;
    row-gap: 20px;
}

.news-v2 > div {
    display: flex;
}

.product-card {
    display: flex;
    flex-direction: column;
    width: 100%;
}

.news-v2-badge {
    height: 230px;
    overflow: hidden;
}

.news-v2-badge img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.news-v2-desc {
    flex: 1;
    padding: 12px 15px;
}

.sm-margin-bottom-20 {
    margin-bottom: 20px !important;
}

@media (max-width: 991px) {
    .news-v2 {
        display: block;
    }

    .news-v2 > div {
        display: block;
    }

    .product-card {
        display: block;
    }

    .news-v2-badge {
        height: auto;
    }

    .news-v2-badge img {
        height: auto;
        object-fit: contain;
    }
}
</style>
