@extends('layout.main')
@section('title', 'Tambah Barter - '.$reseller->name)
@section('content')

<div class="container">
    <form method="POST" action="{{ route('reseller-barters.store', ['reseller' => $reseller->id]) }}">
        @csrf

        <x-input-text
            inRowLabel="Tanggal Barter"
            name="date"
            type="date"
            required
            :value="old('date', date('Y-m-d'))"
            :errorMessage="$errors->first('date')"
        />

        <h5 class="mt-4">Jumlah Barter per Produk</h5>
        <p class="text-muted">Isi 0 jika tidak barter</p>

        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Produk</th>
                        <th>Jumlah</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $product)
                        <tr>
                            <td>{{ $product->name }}</td>
                            <td>
                                <input type="number"
                                       name="products[{{ $product->id }}]"
                                       min="0"
                                       class="form-control"
                                       value="{{ old('products.'.$product->id, 0) }}">
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-between mt-4">
            <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-barters.show', $reseller->id) }}'">
                <i class="bi bi-arrow-left"></i> Kembali
            </x-gold-button>

            <x-button type="submit">
                Tambah Barter
            </x-button>
        </div>

    </form>
</div>

@endsection
