@extends('layout.main')
@section('title', 'Edit Barter - '.$reseller->name)
@section('content')

<div class="container">
    <form method="POST" action="{{ route('reseller-barters.update', $batchId) }}">
        @csrf
        @method('PUT')

        <x-input-text
            inRowLabel="Tanggal Barter"
            name="date"
            type="date"
            required
            :value="old('date', $barterData['date'])"
            :errorMessage="$errors->first('date')"
        />

        <h5 class="mt-4">Jumlah Barter per Produk</h5>
        <p class="text-muted">Isi 0 jika tidak barter</p>

        @error('products')
            <div class="text-danger mb-2">{{ $message }}</div>
        @enderror

        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Produk</th>
                        <th>Jumlah</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $product)
                        <tr>
                            <td>{{ $product->name }}</td>
                            <td>
                                <input type="number"
                                       name="products[{{ $product->id }}]"
                                       min="0"
                                       class="form-control"
                                       value="{{ old('products.'.$product->id, $barterData[$product->id] ?? 0) }}">
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-between mt-4">
            <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-barters.show', $reseller->id) }}'">
                <i class="bi bi-arrow-left"></i> Kembali
            </x-gold-button>

            <x-button type="submit">
                Simpan
            </x-button>
        </div>

    </form>
</div>

@endsection
