@extends('layout.main')
@section('title', 'Bayar Tagihan Reseller')
@section('content')

<div class="container">
    <form method="POST" action="{{ route('reseller-payments.update', $resellerPayment->id) }}">
        @csrf
        @method('PUT')

        <x-input-text
            inRowLabel="Reseller"
            name="reseller_name"
            :value="$resellerPayment->reseller->name ?? '-'"
            disabled
        />

        <x-input-text
            inRowLabel="Invoice Number"
            name="invoice_number"
            :value="$resellerPayment->resellerOrder->invoice_number ?? '-'"
            disabled
        />

        <x-input-text
            inRowLabel="Total Tagihan"
            name="amount_due"
            :value="'Rp ' . number_format($resellerPayment->amount_due, 0, ',', '.')"
            disabled
        />

        <x-input-text
            inRowLabel="Terbayar"
            name="amount_paid"
            :value="'Rp ' . number_format($resellerPayment->amount_paid, 0, ',', '.')"
            disabled
        />

        <x-input-text
            inRowLabel="Sisa Tagihan"
            name="remaining"
            :value="'Rp ' . number_format($remaining, 0, ',', '.')"
            disabled
        />

        <x-input-text
            inRowLabel="Jumlah Pembayaran"
            name="amount"
            type="number"
            required
            min="1"
            :max="$remaining"
            placeholder="Masukkan nominal pembayaran (maks: {{ $remaining }})"
        />

        <x-input-text
            inRowLabel="Tanggal Pembayaran"
            name="payment_date"
            type="date"
            required
            :value="date('Y-m-d')"
        />

        <div class="d-flex justify-content-between mt-4">
            <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-payments.index', $resellerPayment->id) }}'">
                <i class="bi bi-arrow-left"></i> Kembali
            </x-gold-button>

            <x-button type="submit">
                Bayar
            </x-button>
        </div>
    </form>
</div>

@endsection
