@extends('layout.main')
@section('title', 'Detail Pembayaran Reseller')
@section('content')

<div class="container">
    <div class="mb-3">
        <label class="form-label">Reseller</label>
        <input type="text" class="form-control" 
            value="{{ $resellerPayment->reseller->name ?? '-' }}" disabled>
    </div>

    <div class="mb-3">
        <label class="form-label">Tanggal Pesanan</label>
        <input type="text" class="form-control" 
            value="{{ optional($resellerPayment->resellerOrder->order_date)->format('d F Y') ?? '-' }}" disabled>
    </div>

    <div class="mb-3">
        <label class="form-label">No. Nota</label>
        <input type="text" class="form-control" 
            value="{{ $resellerPayment->resellerOrder->invoice_number ?? '-' }}" disabled>
    </div>

    <div class="row mb-3">
        <div class="col-md-4">
            <label class="form-label">Total Tagihan</label>
            <input type="text" class="form-control"
                value="Rp {{ number_format($resellerPayment->amount_due, 0, ',', '.') }}" disabled>
        </div>

        <div class="col-md-4">
            <label class="form-label">Terbayar</label>
            <input type="text" class="form-control"
                value="Rp {{ number_format($resellerPayment->amount_paid, 0, ',', '.') }}" disabled>
        </div>

        <div class="col-md-4">
            <label class="form-label">Sisa</label>
            <input type="text" class="form-control"
                value="Rp {{ number_format($resellerPayment->amount_due - $resellerPayment->amount_paid, 0, ',', '.') }}" disabled>
        </div>
    </div>

    <div class="mb-3">
        <label class="form-label">Status</label>
        <input type="text" class="form-control" 
            value="{{ ucfirst($resellerPayment->status) }}" disabled>
    </div>

    <h5 class="mt-4">History Pembayaran</h5>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Tanggal</th>
                <th>Jumlah</th>
                <th width="120">Aksi</th>
            </tr>
        </thead>
        <tbody>
            @forelse($resellerPayment->histories as $history)
                <tr>
                    <td>{{ $history->payment_date->format('d F Y') }}</td>
                    <td>Rp {{ number_format($history->amount, 0, ',', '.') }}</td>
                    <td>
                        <form 
                            action="{{ route('reseller-payment-histories.destroy', $history->id) }}" 
                            method="POST"
                            onsubmit="return confirm('Yakin ingin menghapus history pembayaran ini?')"
                        >
                            @csrf
                            @method('DELETE')

                            <button type="submit" class="btn px-2 py-1" style="background-color:#8c2b25;color:#ffffff;border-radius:6px;">
                                <i class="bi bi-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="3" class="text-center">Belum ada pembayaran</td>
                </tr>
            @endforelse
        </tbody>
    </table>


    <div class="d-flex justify-content-start mt-4">
        <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-payments.index') }}'">
            <i class="bi bi-arrow-left"></i> Kembali
        </x-gold-button>
    </div>
</div>

@endsection
