@extends('layout.main')
@section('title', 'Update Stok - '.$reseller->name)

@section('content')

<form action="{{ route('reseller-stocks.update', $reseller->id) }}" method="POST">
    @csrf
    @method('PUT')

    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>Produk</th>
                <th>Stok Saat Ini</th>
                <th>Stok Baru (Sisa)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($products as $product)
                @php 
                    $current = $currentStocks[$product->id]->stock ?? 0;
                @endphp

                <tr>
                    <td>{{ $product->name }}</td>

                    <td>
                        <strong>{{ $current }}</strong>
                    </td>

                    <td>
                        <input 
                            type="number"
                            name="stock[{{ $product->id }}]"
                            value="{{ $current }}"
                            max="{{ $current }}"
                            min="0"
                            class="form-control @error('stock.'.$product->id) is-invalid @enderror"
                        >

                        @error('stock.'.$product->id)
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="d-flex justify-content-between mt-4">
        <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-stocks.show', $reseller->id) }}'">
            <i class="bi bi-arrow-left"></i> Kembali
        </x-gold-button>

        <x-button type="submit">
            Simpan
        </x-button>
    </div>
</form>

@endsection
