@extends('layout.main')
@section('title', 'Stock Reseller - ' . $reseller->name)

@section('content')

<div class="row mb-3">
    <div class="col-md-12 d-flex justify-content-start">
        <x-button href="{{ route('reseller-stocks.edit', $reseller->id) }}">
            Update Stock
        </x-button>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-12">
        <form method="GET" action="{{ route('reseller-stocks.show', $reseller->id) }}" class="row g-3">

            <div class="col-md-4">
                <label>Dari Tanggal</label>

                <input 
                    type="text"
                    class="form-control date-display"
                    placeholder="dd/mm/yyyy"
                    value="{{ \Carbon\Carbon::parse(request('start_date', $startDate))->format('d/m/Y') }}"
                >

                <input 
                    type="hidden"
                    name="start_date"
                    class="date-hidden"
                    value="{{ request('start_date', $startDate) }}"
                >
            </div>

            <div class="col-md-4">
                <label>Sampai Tanggal</label>

                <input 
                    type="text"
                    class="form-control date-display"
                    placeholder="dd/mm/yyyy"
                    value="{{ \Carbon\Carbon::parse(request('end_date', $endDate))->format('d/m/Y') }}"
                >

                <input 
                    type="hidden"
                    name="end_date"
                    class="date-hidden"
                    value="{{ request('end_date', $endDate) }}"
                >
            </div>

            <div class="col-md-4 d-flex align-items-end">
                <x-button type="submit">
                    Filter
                </x-button>
            </div>

        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <x-table :headers="$headers" :rows="$tableRows" />
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-12 d-flex justify-content-start">
        <x-gold-button type="button" onclick="window.location.href='{{ route('reseller-stocks.index') }}'">
            <i class="bi bi-arrow-left"></i> Kembali
        </x-gold-button>
    </div>
</div>

@endsection
